/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUUID;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.uddi.WSUDDIUtils;
import filenet.ws.utils.WSConstants;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VWUDDIRegistryList {
    public static final String XML_TAG_WSDL = "WSDL";
    public static final String XML_TAG_UDDI_REGISTRY_LIST = "UDDIRegistryList";
    public static final String XML_TAG_BUSINESS_ENTITY = "businessEntity";
    public static final String UDDI_TAG = "UDDIRegistryList";
    public static final String XML_ATTRIBUTE_ENABLE_REGION_BUSINESS_ENTITY = "enableRegionBusinessEntity";
    public static final String XML_ATTRIBUTE_ALLOW_USER_ENTER_WSDL = "allowUserEnterWSDL";
    public static final String XML_ATTRIBUTE_VERSION = "Version";
    public static final String XML_VERSION_1_0 = "1.0";
    public static final String VW_UDDI_NAME_SPACE = "http://filenet.com/vw/base/UDDIRegistryList/1.0";
    public static final String ATTRINFO_CONFIG_UDDI_REGISTRIES = "F_UDDIRegistries";
    private static final String REGION_BUSINESS_AUTHORIZEDNAME = "PE";
    private static final String REGION_BUSINESS_OPERATOR = "FileNet";
    protected Element base = null;
    private boolean m_bEnableRegionBusiness = false;
    private VWAttributeInfo m_vwAttributeInfo = null;
    private VWSession m_vwSession = null;
    private Vector m_uddiRegistryVector = new Vector();
    private BusinessEntity m_regionBusinessEntity = null;
    private String m_key = "F_UDDIRegistries";
    private boolean m_bAllowUserEnterWSDL = false;
    private VWXMLWrapper m_xmlWrapper = null;
    private static Logger m_logger = Logger.getLogger("filenet.vw.base");
    private static final String m_className = "VWUDDIRegistryList";

    public static String _get_FILE_DATE() {
        return "$Date:   07 Aug 2007 15:51:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.22  $";
    }

    public VWUDDIRegistryList(VWSession session) {
        try {
            this.m_vwSession = session;
            if (this.m_vwSession != null) {
                VWSystemConfiguration sysConfig = this.m_vwSession.fetchSystemConfiguration();
                this.m_vwAttributeInfo = sysConfig.getAttributeInfo();
                this.fetchUDDIRegistryList();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWUDDIRegistryList(VWAttributeInfo vwAttributeInfo, VWSession session) {
        this.m_vwAttributeInfo = vwAttributeInfo;
        this.m_vwSession = session;
        this.fetchUDDIRegistryList();
    }

    public VWUDDIRegistryList(VWAttributeInfo vwAttributeInfo, String sUDDIxml, VWSession session) throws Exception {
        this.m_vwAttributeInfo = vwAttributeInfo;
        this.m_vwSession = session;
        this.parseXML(sUDDIxml);
    }

    public Vector getUDDIRegistryVector() {
        return this.m_uddiRegistryVector;
    }

    public VWUDDIRegistry getUDDIRegistry(String uddiName) {
        VWUDDIRegistry vwUDDIRegistry = null;
        if (uddiName != null && uddiName.length() > 0 && this.m_uddiRegistryVector != null && this.m_uddiRegistryVector.size() > 0) {
            boolean bFind = false;
            for (int i = 0; i < this.m_uddiRegistryVector.size(); ++i) {
                vwUDDIRegistry = (VWUDDIRegistry)this.m_uddiRegistryVector.elementAt(i);
                if (uddiName.compareTo(vwUDDIRegistry.getName()) != 0) continue;
                bFind = true;
                break;
            }
            if (!bFind) {
                vwUDDIRegistry = null;
            }
        }
        return vwUDDIRegistry;
    }

    public VWUDDIRegistry[] getUDDIRegistries() {
        Object[] arrayList = null;
        if (this.m_uddiRegistryVector != null && this.m_uddiRegistryVector.size() > 0) {
            arrayList = new VWUDDIRegistry[this.m_uddiRegistryVector.size()];
            this.m_uddiRegistryVector.copyInto(arrayList);
        }
        return arrayList;
    }

    public VWUDDIRegistry[] getPublishableUDDIRegistries() {
        int sz;
        Object[] arrayList = null;
        if (this.m_uddiRegistryVector != null && (sz = this.m_uddiRegistryVector.size()) > 0) {
            Vector<VWUDDIRegistry> tmpVector = new Vector<VWUDDIRegistry>();
            for (int i = 0; i < sz; ++i) {
                VWUDDIRegistry uddiReg = (VWUDDIRegistry)this.m_uddiRegistryVector.elementAt(i);
                if (!uddiReg.isPublishable()) continue;
                tmpVector.add(uddiReg);
            }
            int len = tmpVector.size();
            if (len > 0) {
                arrayList = new VWUDDIRegistry[len];
                tmpVector.copyInto(arrayList);
            }
        }
        return arrayList;
    }

    public boolean getEnableRegionBusinessEntity() {
        return this.m_bEnableRegionBusiness;
    }

    public void setEnableRegionBusinessEntity(boolean bEnable) {
        this.m_bEnableRegionBusiness = bEnable;
    }

    public boolean getAllowUserEnterWSDL() {
        return this.m_bAllowUserEnterWSDL;
    }

    public void setAllowUserEnterWSDL(boolean bAllow) {
        this.m_bAllowUserEnterWSDL = bAllow;
    }

    public void setUDDIRegistryVector(Vector uddiRegistryList) {
        this.m_uddiRegistryVector = uddiRegistryList;
    }

    public void setUDDIRegistries(VWUDDIRegistry[] uddiRegistryArray) {
        if (this.m_uddiRegistryVector == null) {
            this.m_uddiRegistryVector = new Vector();
        } else {
            this.m_uddiRegistryVector.clear();
        }
        if (uddiRegistryArray == null) {
            return;
        }
        int sz = uddiRegistryArray.length;
        if (sz <= 0) {
            return;
        }
        for (int i = 0; i < sz; ++i) {
            this.m_uddiRegistryVector.add(uddiRegistryArray[i]);
        }
    }

    public BusinessEntity getRegionBusinessEntity() {
        return this.m_regionBusinessEntity;
    }

    public void setRegionBusinessEntity(BusinessEntity regionBusinessEntity) {
        this.m_regionBusinessEntity = regionBusinessEntity;
    }

    public void updateAttribute() {
        try {
            String sUDDIxml = this.toXML();
            this.m_vwAttributeInfo.setFieldValue(this.m_key, sUDDIxml);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void save(VWSession session) {
        try {
            this.updateAttribute();
            VWSystemConfiguration sysConfig = session.fetchSystemConfiguration();
            sysConfig.setAttributeInfo(this.m_vwAttributeInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void saveAndCommit(VWSession session) {
        try {
            this.updateAttribute();
            VWSystemConfiguration sysConfig = session.fetchSystemConfiguration();
            sysConfig.setAttributeInfo(this.m_vwAttributeInfo);
            sysConfig.commit();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String toXML() {
        return this.toXML_v1();
    }

    public String toXML_v0() {
        String sAllow = this.m_bAllowUserEnterWSDL ? "1" : "0";
        String sXML = "<UDDIRegistryList allowUserEnterWSDL=\"" + sAllow + "\">";
        int sz = this.m_uddiRegistryVector.size();
        String s = null;
        for (int i = 0; i < sz; ++i) {
            s = ((VWUDDIRegistry)this.m_uddiRegistryVector.elementAt(i)).toXML();
            if (s == null) continue;
            sXML = sXML + s;
        }
        sXML = sXML + "</UDDIRegistryList>";
        return sXML;
    }

    public String toXML_v1() {
        String xmlString = null;
        try {
            Document doc = this.saveToDOM();
            if (this.m_xmlWrapper == null) {
                this.m_xmlWrapper = new VWXMLWrapper("UDDIRegistryList", VW_UDDI_NAME_SPACE);
            }
            xmlString = this.m_xmlWrapper.toXML(doc);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return xmlString;
    }

    public void releaseResources() {
        this.m_vwAttributeInfo = null;
        if (this.m_uddiRegistryVector != null) {
            int sz = this.m_uddiRegistryVector.size();
            for (int i = 0; i < sz; ++i) {
                ((VWUDDIRegistry)this.m_uddiRegistryVector.elementAt(i)).releaseResources();
            }
            this.m_uddiRegistryVector.clear();
            this.m_uddiRegistryVector = null;
        }
        this.m_key = null;
    }

    public void mergeBusinessEntities(VWUDDIRegistry sourceUDDIRegistry, VWUDDIRegistry destUDDIRegistry) {
        Vector destVector = destUDDIRegistry.getBusinessEntityVector();
        Vector sourceVector = sourceUDDIRegistry.getBusinessEntityVector();
        if (destVector == null || destVector.size() <= 0) {
            destUDDIRegistry.setBusinessEntityVector(sourceVector);
            return;
        }
        int sz = sourceVector.size();
        block0: for (int i = 0; i < sz; ++i) {
            VWUDDIBusinessEntity sourceBN = (VWUDDIBusinessEntity)sourceVector.elementAt(i);
            if (sourceBN == null) continue;
            String sourceName = null;
            if (sourceBN.getName(0) != null) {
                sourceName = sourceBN.getName(0).getValue();
            }
            if (sourceName == null || sourceName.length() < 1) continue;
            int len = destVector.size();
            boolean bFound = false;
            for (int j = 0; j < len; ++j) {
                VWUDDIBusinessEntity destBN = (VWUDDIBusinessEntity)destVector.elementAt(i);
                if (destBN == null) continue;
                String destName = null;
                if (destBN.getName(0) != null) {
                    destName = destBN.getName(0).getValue();
                }
                if (destName == null || destName.length() < 1) continue;
                if (sourceName.compareTo(destName) == 0) {
                    bFound = true;
                    String dBusinessKey = destBN.getBusinessKey();
                    String sBusinessKey = sourceBN.getBusinessKey();
                    if ((dBusinessKey == null || dBusinessKey.length() <= 0) && sBusinessKey != null && sBusinessKey.length() > 0) {
                        destBN.setBusinessKey(sBusinessKey);
                    }
                    String dUserName = destBN.getAuthorizedName();
                    String sUserName = sourceBN.getAuthorizedName();
                    if (dUserName != null && dUserName.length() > 0 || sUserName == null || sUserName.length() <= 0) continue block0;
                    destBN.setAuthorizedName(sUserName);
                    continue block0;
                }
                if (bFound) continue;
                destVector.add(sourceBN);
            }
        }
    }

    public void mergeRegistrList(VWUDDIRegistryList sourceList) throws VWException {
        try {
            Vector sourceRegistryVector;
            Contacts sourceContacts;
            if (sourceList == null) {
                return;
            }
            BusinessEntity sourceRegionBE = sourceList.getRegionBusinessEntity();
            if (sourceRegionBE != null && (sourceContacts = sourceRegionBE.getContacts()) != null) {
                Vector sourceContactVector = sourceContacts.getContactVector();
                int sourceSz = 0;
                if (sourceContactVector != null) {
                    sourceSz = sourceContactVector.size();
                }
                if (sourceSz > 0) {
                    if (this.m_regionBusinessEntity == null) {
                        this.setDefaultRegionBusinessEntity();
                        this.m_regionBusinessEntity.setContacts(sourceContacts);
                    } else {
                        Contacts currentContacts = this.m_regionBusinessEntity.getContacts();
                        if (currentContacts == null) {
                            this.m_regionBusinessEntity.setContacts(sourceContacts);
                        } else {
                            Vector currentContactVector = currentContacts.getContactVector();
                            if (currentContactVector == null || currentContactVector.size() == 0) {
                                currentContacts.setContactVector(sourceContactVector);
                                this.m_regionBusinessEntity.setContacts(currentContacts);
                            } else {
                                int currentSz = currentContactVector.size();
                                for (int i = 0; i < sourceSz; ++i) {
                                    Contact sContact = (Contact)sourceContactVector.elementAt(i);
                                    String sContactName = sContact.getPersonNameValue();
                                    boolean bfound = false;
                                    for (int j = 0; j < currentSz; ++j) {
                                        String cContactName;
                                        Contact cContact = (Contact)currentContactVector.elementAt(j);
                                        if (cContact == null || (cContactName = cContact.getPersonNameValue()) == null || cContactName.length() < 1 || sContactName.compareTo(cContactName) != 0) continue;
                                        bfound = true;
                                        break;
                                    }
                                    if (bfound) continue;
                                    currentContactVector.addElement(sContact);
                                }
                            }
                        }
                    }
                }
            }
            if ((sourceRegistryVector = sourceList.getUDDIRegistryVector()) == null || sourceRegistryVector.size() <= 0) {
                return;
            }
            int sourceListLen = sourceRegistryVector.size();
            int currentListLen = 0;
            if (this.m_uddiRegistryVector != null) {
                currentListLen = this.m_uddiRegistryVector.size();
            }
            if (currentListLen == 0) {
                this.m_uddiRegistryVector = sourceRegistryVector;
                return;
            }
            String sourceName = null;
            String destName = null;
            for (int i = 0; i < sourceListLen; ++i) {
                VWUDDIRegistry sourceUDDIRegistry = (VWUDDIRegistry)sourceRegistryVector.elementAt(i);
                if (sourceUDDIRegistry == null || (sourceName = sourceUDDIRegistry.getName()) == null || sourceName.length() <= 0) continue;
                if (currentListLen == 0) {
                    this.m_uddiRegistryVector.add(sourceRegistryVector.elementAt(i));
                    continue;
                }
                boolean bFound = false;
                for (int j = 0; j < currentListLen; ++j) {
                    VWUDDIRegistry destUDDIRegistry = (VWUDDIRegistry)this.m_uddiRegistryVector.elementAt(j);
                    if (destUDDIRegistry == null || (destName = destUDDIRegistry.getName()) == null || destName.length() <= 0 || sourceName.compareTo(destName) != 0) continue;
                    bFound = true;
                    this.mergeBusinessEntities(sourceUDDIRegistry, destUDDIRegistry);
                    break;
                }
                if (bFound) continue;
                this.m_uddiRegistryVector.add(sourceRegistryVector.elementAt(i));
            }
            return;
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWUDDIRegistryList.MergeUDDIRegistries", "Failed to merge UDDI registry. {0}", ex.getMessage());
        }
    }

    public void setDefaultRegionBusinessEntity() throws VWException {
        if (this.m_vwSession != null) {
            this.m_regionBusinessEntity = new BusinessEntity();
            VWUUID keyUUID = VWUUID.randomUUID();
            String strBusinessKey = keyUUID.toString();
            this.m_regionBusinessEntity.setBusinessKey("uuid:" + strBusinessKey);
            this.m_regionBusinessEntity.setContacts(new Contacts());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseXML(String sUDDIxml) throws VWException {
        try {
            if (this.m_uddiRegistryVector == null) {
                this.m_uddiRegistryVector = new Vector();
            }
            if (sUDDIxml != null && sUDDIxml.length() > 0) {
                this.m_xmlWrapper = new VWXMLWrapper(sUDDIxml);
                Node registryList = this.m_xmlWrapper.getRootNode();
                NamedNodeMap attributes = registryList.getAttributes();
                Node versionAttrNode = attributes.getNamedItem(XML_ATTRIBUTE_VERSION);
                if (versionAttrNode != null) {
                    String sVersion = versionAttrNode.getNodeValue();
                    if (sVersion != null) {
                        if (sVersion.compareTo(XML_VERSION_1_0) != 0) throw new VWException("filenet.vw.base.VWUDDIRegistryList.ParseXML", "version {0} is not supported.", sVersion);
                        this.parseXML_v1_0(registryList);
                        return;
                    } else {
                        this.parseXML_v0(registryList);
                    }
                    return;
                } else {
                    this.parseXML_v0(registryList);
                }
                return;
            } else {
                this.setDefaultRegionBusinessEntity();
            }
            return;
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWUDDIRegistryList.ParseXML", "Failed to parse UDDI registry XML. {0}", ex.getMessage());
        }
    }

    protected void parseXML_v1_0(Node registryList) throws VWException {
        String m_method = "parseXML_v1_0:";
        try {
            if (registryList != null) {
                NamedNodeMap attributes = registryList.getAttributes();
                Node attribute = attributes.getNamedItem(XML_ATTRIBUTE_ENABLE_REGION_BUSINESS_ENTITY);
                if (attribute != null) {
                    String sEnabled = attribute.getNodeValue();
                    if (sEnabled != null) {
                        this.m_bEnableRegionBusiness = sEnabled.compareTo("1") == 0;
                    }
                } else {
                    this.m_bAllowUserEnterWSDL = false;
                }
                attribute = attributes.getNamedItem(XML_ATTRIBUTE_ALLOW_USER_ENTER_WSDL);
                if (attribute != null) {
                    String sAllow = attribute.getNodeValue();
                    if (sAllow != null) {
                        this.m_bAllowUserEnterWSDL = sAllow.compareTo("1") == 0;
                    }
                } else {
                    this.m_bAllowUserEnterWSDL = false;
                }
                NodeList nodeList = registryList.getChildNodes();
                String nodeName = null;
                Node node = null;
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = nodeList.item(i);
                        if (node == null || !(node instanceof Element)) continue;
                        Element uddiRegistryEle = (Element)node;
                        nodeName = uddiRegistryEle.getNodeName();
                        if (nodeName.compareTo(XML_TAG_BUSINESS_ENTITY) == 0) {
                            this.m_regionBusinessEntity = WSUDDIUtils.createBusinessEntity((Element)node);
                            continue;
                        }
                        if (nodeName.compareTo("UDDIRegistry") != 0) continue;
                        VWUDDIRegistry theUDDIRegistry = new VWUDDIRegistry((Element)node);
                        this.m_uddiRegistryVector.add(theUDDIRegistry);
                    }
                }
                if (this.m_regionBusinessEntity == null) {
                    this.setDefaultRegionBusinessEntity();
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWUDDIRegistryList.ParseXML", "Failed to parse UDDI registry XML. {0}", ex.getMessage());
        }
    }

    protected void parseXML_v0(Node registryList) throws VWException {
        String m_method = "parseXML_v0:";
        try {
            if (registryList != null) {
                NamedNodeMap attributes = registryList.getAttributes();
                Node attribute = attributes.getNamedItem(XML_ATTRIBUTE_ALLOW_USER_ENTER_WSDL);
                if (attribute != null) {
                    String sAllow = attribute.getNodeValue();
                    if (sAllow != null) {
                        this.m_bAllowUserEnterWSDL = sAllow.compareTo("1") == 0;
                    }
                } else {
                    this.m_bAllowUserEnterWSDL = false;
                }
                NodeList nodeList = registryList.getChildNodes();
                String nodeName = null;
                Node node = null;
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = nodeList.item(i);
                        if (node == null || !(node instanceof Element)) continue;
                        Element uddiRegistryEle = (Element)node;
                        nodeName = uddiRegistryEle.getNodeName();
                        String sUDDIName = uddiRegistryEle.getAttribute("name");
                        String sInquiryURL = uddiRegistryEle.getAttribute("inquiryURL");
                        String sPublishURL = uddiRegistryEle.getAttribute("publishURL");
                        String sPublish = uddiRegistryEle.getAttribute("publish");
                        String sBusinessName = uddiRegistryEle.getAttribute("businessName");
                        String sBusinessDescription = uddiRegistryEle.getAttribute("businessDescription");
                        String sBusinessKey = uddiRegistryEle.getAttribute("businessKey");
                        String sUsername = uddiRegistryEle.getAttribute("userName");
                        boolean bPublish = false;
                        if (sPublish.equals("1")) {
                            bPublish = true;
                        }
                        VWUDDIRegistry theUDDIRegistry = new VWUDDIRegistry(WSConstants.UTF8Decode(sUDDIName), WSConstants.UTF8Decode(sInquiryURL), WSConstants.UTF8Decode(sPublishURL), bPublish, WSConstants.UTF8Decode(sBusinessName), WSConstants.UTF8Decode(sBusinessDescription), WSConstants.UTF8Decode(sBusinessKey), WSConstants.UTF8Decode(sUsername));
                        this.m_uddiRegistryVector.add(theUDDIRegistry);
                    }
                }
                if (this.m_regionBusinessEntity == null) {
                    this.setDefaultRegionBusinessEntity();
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWUDDIRegistryList.ParseXML_v0", "Failed to parse UDDI registry XML. {0}", ex.getMessage());
        }
    }

    protected void parseXML_v0(String sUDDIxml) throws VWException {
        String m_method = "parseXML_v0:";
        try {
            if (this.m_uddiRegistryVector == null) {
                this.m_uddiRegistryVector = new Vector();
            }
            if (sUDDIxml != null && sUDDIxml.length() > 0) {
                this.m_xmlWrapper = new VWXMLWrapper(sUDDIxml);
                Node registryList = this.m_xmlWrapper.getRootNode();
                NamedNodeMap attributes = registryList.getAttributes();
                Node attribute = attributes.getNamedItem(XML_ATTRIBUTE_ALLOW_USER_ENTER_WSDL);
                if (attribute != null) {
                    String sAllow = attribute.getNodeValue();
                    if (sAllow != null) {
                        this.m_bAllowUserEnterWSDL = sAllow.compareTo("1") == 0;
                    }
                } else {
                    this.m_bAllowUserEnterWSDL = false;
                }
                NodeList nodeList = registryList.getChildNodes();
                String nodeName = null;
                Node node = null;
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = nodeList.item(i);
                        if (node == null || !(node instanceof Element)) continue;
                        Element uddiRegistryEle = (Element)node;
                        nodeName = uddiRegistryEle.getNodeName();
                        String sUDDIName = uddiRegistryEle.getAttribute("name");
                        String sInquiryURL = uddiRegistryEle.getAttribute("inquiryURL");
                        String sPublishURL = uddiRegistryEle.getAttribute("publishURL");
                        String sPublish = uddiRegistryEle.getAttribute("publish");
                        String sBusinessName = uddiRegistryEle.getAttribute("businessName");
                        String sBusinessDescription = uddiRegistryEle.getAttribute("businessDescription");
                        String sBusinessKey = uddiRegistryEle.getAttribute("businessKey");
                        String sUsername = uddiRegistryEle.getAttribute("userName");
                        boolean bPublish = false;
                        if (sPublish.equals("1")) {
                            bPublish = true;
                        }
                        VWUDDIRegistry theUDDIRegistry = new VWUDDIRegistry(WSConstants.UTF8Decode(sUDDIName), WSConstants.UTF8Decode(sInquiryURL), WSConstants.UTF8Decode(sPublishURL), bPublish, WSConstants.UTF8Decode(sBusinessName), WSConstants.UTF8Decode(sBusinessDescription), WSConstants.UTF8Decode(sBusinessKey), WSConstants.UTF8Decode(sUsername));
                        this.m_uddiRegistryVector.add(theUDDIRegistry);
                    }
                }
                if (this.m_regionBusinessEntity == null) {
                    this.setDefaultRegionBusinessEntity();
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWUDDIRegistryList.ParseXML", "Failed to parse UDDI registry XML. {0}", ex.getMessage());
        }
    }

    public Document saveToDOM() {
        Document document = null;
        try {
            document = XMLHelper.newDocumentViaDOM();
            Element rootNode = document.createElement("UDDIRegistryList");
            document.appendChild(rootNode);
            rootNode = document.getDocumentElement();
            rootNode.setAttribute("xmlns", VW_UDDI_NAME_SPACE);
            rootNode.appendChild(document.createTextNode("\n"));
            rootNode.setAttribute(XML_ATTRIBUTE_VERSION, XML_VERSION_1_0);
            rootNode.setAttribute(XML_ATTRIBUTE_ENABLE_REGION_BUSINESS_ENTITY, this.m_bEnableRegionBusiness ? "1" : "0");
            if (this.m_regionBusinessEntity != null) {
                WSUDDIUtils.saveToXML(rootNode, this.m_regionBusinessEntity);
            }
            if (this.m_uddiRegistryVector != null) {
                int sz = this.m_uddiRegistryVector.size();
                for (int i = 0; i < sz; ++i) {
                    ((VWUDDIRegistry)this.m_uddiRegistryVector.elementAt(i)).saveToXML(rootNode);
                }
            }
        }
        catch (Exception ex) {
            m_logger.log(Level.FINE, "VWUDDIRegistryList::saveToXML.", ex);
            VWDebug.logException(ex);
        }
        return document;
    }

    private void fetchUDDIRegistryList() {
        String m_method = "fetchUDDIRegistryList:";
        try {
            String sUDDIxml = (String)this.m_vwAttributeInfo.getFieldValue(this.m_key);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.finest(m_className, m_method, sUDDIxml);
            }
            this.clearUDDIRegistryVector();
            this.parseXML(sUDDIxml);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void clearUDDIRegistryVector() {
        int sz = this.m_uddiRegistryVector.size();
        for (int i = 0; i < sz; ++i) {
            ((VWUDDIRegistry)this.m_uddiRegistryVector.elementAt(i)).releaseResources();
        }
        this.m_uddiRegistryVector.clear();
    }

    private void dumpXml(String strXML, String filePath) {
        try {
            FileOutputStream outStream = new FileOutputStream(filePath);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outStream, "UTF8");
            out.write(strXML);
            ((Writer)out).flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

